import 'package:ebroker/data/cubits/property/fetch_city_property_list.dart';
import 'package:ebroker/exports/main_export.dart';
import 'package:ebroker/ui/screens/home/city_properties_screen.dart';
import 'package:flutter/material.dart';

class CustomImageGrid extends StatelessWidget {
  const CustomImageGrid({required this.images, super.key});

  final List<String> images;

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final width = constraints.maxWidth * 0.9;
        final itemWidth = width / 2;
        final standardHeight = itemWidth;
        final doubleHeight = (standardHeight * 2) + 5;
        final state = context.read<FetchCityCategoryCubit>().state
            as FetchCityCategorySuccess;

        // Get the actual number of cities
        final cityCount = state.cities.length;

        // If no cities, return empty container
        if (cityCount == 0) {
          return const SizedBox.shrink();
        }

        return Padding(
          padding: const EdgeInsetsDirectional.only(start: 15),
          child: Column(
            children: [
              // First row
              Row(
                children: [
                  Column(
                    children: [
                      _buildImageContainer(
                        index: 0,
                        width: itemWidth,
                        height: standardHeight,
                        state: state,
                        context: context,
                      ),
                      if (cityCount > 1)
                        _buildImageContainer(
                          index: 1,
                          width: itemWidth,
                          height: standardHeight,
                          state: state,
                          context: context,
                        ),
                    ],
                  ),
                  if (cityCount > 2)
                    _buildImageContainer(
                      index: 2,
                      width: itemWidth,
                      height: doubleHeight,
                      state: state,
                      context: context,
                    ),
                ],
              ),

              // Only show additional rows if we have more cities
              if (cityCount > 3) ...[
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.end,
                      children: [
                        _buildImageContainer(
                          index: 3,
                          width: itemWidth,
                          height: standardHeight,
                          state: state,
                          context: context,
                        ),
                        if (cityCount > 5)
                          _buildImageContainer(
                            index: 5,
                            width: itemWidth,
                            height: doubleHeight,
                            state: state,
                            context: context,
                          ),
                      ],
                    ),
                    Column(
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        if (cityCount > 4)
                          _buildImageContainer(
                            index: 4,
                            width: itemWidth,
                            height: doubleHeight,
                            state: state,
                            context: context,
                          ),
                        if (cityCount > 6)
                          _buildImageContainer(
                            index: 6,
                            width: itemWidth,
                            height: standardHeight,
                            state: state,
                            context: context,
                          ),
                      ],
                    ),
                  ],
                ),
              ],

              // Only show the last row if we have more than 7 cities
              if (cityCount > 7) ...[
                Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    _buildImageContainer(
                      index: 7,
                      width: itemWidth,
                      height: doubleHeight,
                      state: state,
                      context: context,
                    ),
                    Column(
                      children: [
                        if (cityCount > 8)
                          _buildImageContainer(
                            index: 8,
                            width: itemWidth,
                            height: standardHeight,
                            state: state,
                            context: context,
                          ),
                        if (cityCount > 9)
                          _buildImageContainer(
                            index: 9,
                            width: itemWidth,
                            height: standardHeight,
                            state: state,
                            context: context,
                          ),
                      ],
                    ),
                  ],
                ),
              ],
            ],
          ),
        );
      },
    );
  }

  Widget _buildImageContainer({
    required int index,
    required double width,
    required double height,
    required FetchCityCategorySuccess state,
    required BuildContext context,
  }) {
    if (index >= state.cities.length) {
      return SizedBox(
        width: width,
        height: height,
      );
    }
    final city = state.cities[index];
    return Container(
      width: width,
      height: height,
      margin: const EdgeInsets.all(2),
      child: ClipRRect(
        borderRadius: BorderRadius.circular(15),
        child: GestureDetector(
          onTap: () {
            context.read<FetchCityPropertyList>().fetch(
                  cityName: city.name,
                  forceRefresh: true,
                );
            Navigator.push(
              context,
              MaterialPageRoute<dynamic>(
                builder: (context) {
                  return CityPropertiesScreen(
                    cityName: city.name,
                  );
                },
              ),
            );
          },
          child: Stack(
            fit: StackFit.expand,
            children: [
              UiUtils.getImage(
                city.image,
                fit: BoxFit.cover,
              ),
              Container(
                decoration: BoxDecoration(
                  gradient: LinearGradient(
                    begin: Alignment.bottomCenter,
                    end: Alignment.topCenter,
                    colors: [
                      Colors.black.withValues(alpha: 0.68),
                      Colors.black.withValues(alpha: 0),
                    ],
                  ),
                ),
              ),
              PositionedDirectional(
                bottom: 8,
                start: 12,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    CustomText(
                      city.name.firstUpperCase(),
                      color: context.color.buttonColor,
                      fontSize: context.font.normal,
                    ),
                    const SizedBox(
                      height: 2,
                    ),
                    CustomText(
                      '${city.count} ${'properties'.translate(context)}',
                      color: context.color.buttonColor,
                      fontSize: context.font.small,
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
